/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.mysticalagriculture.tileentity.TinkeringTableTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TinkeringTableBlock
extends BaseTileEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape TABLE_SHAPE = VoxelShapeBuilder.builder().cuboid(1.0, 0.0, 1.0, 15.0, 4.0, 15.0).cuboid(3.5, 5.0, 3.5, 12.5, 9.0, 12.5).cuboid(0.0, 10.0, 0.0, 16.0, 13.0, 16.0).cuboid(1.0, 13.0, 1.0, 15.0, 14.0, 15.0).cuboid(2.5, 4.0, 2.5, 13.5, 5.0, 13.5).cuboid(2.5, 9.0, 2.5, 13.5, 10.0, 13.5).cuboid(0.0, 0.0, 0.0, 1.0, 3.0, 3.0).cuboid(0.0, 0.0, 13.0, 1.0, 3.0, 16.0).cuboid(15.0, 0.0, 0.0, 16.0, 3.0, 3.0).cuboid(15.0, 0.0, 13.0, 16.0, 3.0, 16.0).cuboid(1.0, 0.0, 0.0, 3.0, 3.0, 1.0).cuboid(13.0, 0.0, 0.0, 15.0, 3.0, 1.0).cuboid(1.0, 0.0, 15.0, 3.0, 3.0, 16.0).cuboid(13.0, 0.0, 15.0, 15.0, 3.0, 16.0).build();

    public TinkeringTableBlock() {
        super(SoundType.STONE, 10.0f, 12.0f, true);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TinkeringTableTileEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof TinkeringTableTileEntity) {
            TinkeringTableTileEntity table = (TinkeringTableTileEntity)tile;
            player.openMenu((MenuProvider)table, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof TinkeringTableTileEntity) {
            TinkeringTableTileEntity table = (TinkeringTableTileEntity)tile;
            ItemStack stack = table.getInventory().getStackInSlot(0);
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return TABLE_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return BlockHelper.getRedstoneSignalFromInventory((BlockEntity)level.getBlockEntity(pos));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

